' Lite version -

' DS4QB++ master moduole -- Header file

' Prototypes

' Internal functions
DECLARE SUB StopSend (Handle AS INTEGER)
DECLARE SUB StopReceive (Handle AS INTEGER)
DECLARE SUB SendMessage ()
DECLARE SUB WaitConfirm ()
DECLARE SUB DeleteFiles ()
DECLARE FUNCTION NotReady% ()
DECLARE FUNCTION ReadySend% ()
DECLARE FUNCTION ReadyReceive% ()
DECLARE FUNCTION FileExsist% (File AS STRING)

DECLARE SUB INTERRUPTX (IntNum AS INTEGER, InReg AS ANY, OutReg AS ANY)

' Constants

' Communication
CONST OUTFILE = "SOUNDSYS\DS4QB.QBW"
CONST INFILE = "SOUNDSYS\DS4QB.VCW"
CONST SENDCONFIRM = "SOUNDSYS\DS4QB.QBS"
CONST RECEIVECONFIRM = "SOUNDSYS\DS4QB.VCS"

' Message id's
CONST CMD.CLOSE = 1
CONST CMD.RESET = 2
CONST CMD.LOADSND = 3
CONST CMD.PLAYSND = 4
CONST CMD.SETSNDATTR = 5
CONST CMD.GETSNDATTR = 6
CONST CMD.LOADMUSIC = 7
CONST CMD.PLAYMUSIC = 8
CONST CMD.SETMUSICATTR = 9
CONST CMD.STOPSND = 11
CONST CMD.PAUSEMUSIC = 12
CONST CMD.RESUMEMUSIC = 13
CONST CMD.STOPMUSIC = 14
CONST CMD.DELETESND = 15
CONST CMD.DELETEMUSIC = 16
CONST CMD.SETVOLUME = 17
CONST CMD.SETGLOBALVOLUMES = 18
CONST CMD.PLAYSOUNDS = 28

' Types

' RegTypeX
TYPE RegTypeX
 Ax          AS INTEGER
 Bx          AS INTEGER
 Cx          AS INTEGER
 Dx          AS INTEGER
 Bp          AS INTEGER
 Si          AS INTEGER
 Di          AS INTEGER
 Flags       AS INTEGER
 Ds          AS INTEGER
 Es          AS INTEGER
END TYPE

' CMD.INITIALIZE chunk
TYPE CHUNKxCMDxINITIALIZE
 ID          AS INTEGER
 Quality     AS LONG
 Flags       AS LONG
END TYPE

' CMD.CLOSE chunk
TYPE CHUNKxCMDxCLOSE
 ID          AS INTEGER
END TYPE

' CMD.LOADSND chunk
TYPE CHUNKxCMDxLOADSND
 ID          AS INTEGER
 Slot        AS INTEGER
 FileName    AS STRING * 64
 Flags       AS LONG
END TYPE

' CMD.PLAYSND chunk
TYPE CHUNKxCMDxPLAYSND
 ID          AS INTEGER
 Slot        AS INTEGER
 Freq        AS LONG
 Volume      AS INTEGER
 Pan         AS INTEGER
 Looping     AS INTEGER
END TYPE

' CMD.STOPSND chunk
TYPE CHUNKxCMDxSTOPSND
 ID          AS INTEGER
 Slot        AS INTEGER
END TYPE

' CMD.SETSNDATTR
TYPE CHUNKxCMDxSETSNDATTR
 ID          AS INTEGER
 Slot        AS INTEGER
 Freq        AS LONG
 Volume      AS INTEGER
 Pan         AS INTEGER
 Looping     AS INTEGER
 Flags       AS LONG
END TYPE

' ...
TYPE CHUNKxGENERIC2INT
 ID          AS INTEGER
 Value       AS INTEGER
END TYPE

' CMD.LOADMUSIC chunk
TYPE CHUNKxCMDxLOADMUSIC
 ID          AS INTEGER
 Slot        AS INTEGER
 FileName    AS STRING * 64
 Flags       AS LONG
 MusicType   AS INTEGER
END TYPE

' CMD.SETMUSICATTR chunk
TYPE CHUNKxCMDxSETMUSICATTR
 ID          AS INTEGER
 Slot        AS INTEGER
 Pan         AS INTEGER
 Amp         AS INTEGER
END TYPE

' CMD.PLAYSOUNDS chunk
TYPE CHUNKxCMDxPLAYSOUNDS
 ID          AS INTEGER
 SndCount    AS INTEGER
END TYPE

' Internal globals

DIM SHARED OS, xSound, xMusic, SndCount
DIM SHARED SoundQue(64) AS CHUNKxCMDxPLAYSND
'          ^-- (0.8KB)